//////////
//
//	File:		VRMovies.h
//
//	Contains:	Support for QuickTime movie playback in VR nodes.
//
//	Written by:	Tim Monroe
//
//	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	12/11/96	rtm		first file 
//	   
//////////

#pragma once

//////////
//
// header files
//	   
//////////

#include "ComApplication.h"
#include "VRScript.h"

#if TARGET_OS_MAC
#include "MacFramework.h"
#endif

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif


//////////
//
// compiler flags
//	   
//////////

// Do we use CopyBits or DecompressImage to copy an embedded movie into the back buffer?
// (see Ice Floe Dispatch 8 for details); my preliminary tests indicate that there is no
// real advantage to using DecompressImage here, but I have not done extensive profiling.
#ifndef USE_COPYBITS_TO_BACKBUFFER
#define USE_COPYBITS_TO_BACKBUFFER	1
#endif

// Do we allow on-the-fly rotation of backbuffer movies? (this was useful in versions of
// QTVR that used a vertical back buffer, but is no longer worth the trouble....)
#ifndef ALLOW_REALTIME_ROTATION
#define ALLOW_REALTIME_ROTATION	0
#endif


//////////
//
// constants
//	   
//////////


//////////
//
// function prototypes
//	   
//////////

void								VRMoov_Init (void);
void								VRMoov_Stop (void);
void								VRMoov_StartMovie (Movie theMovie);
void								VRMoov_PlayMovie (WindowObject theWindowObject, UInt32 theNodeID, UInt32 theEntryID, float thePanAngle, float theTiltAngle, float theScale, float theWidth, UInt32 theKeyRed, UInt32 theKeyGreen, UInt32 theKeyBlue, Boolean theUseBuffer, Boolean theUseCenter, Boolean theUseKey, Boolean theUseHide, Boolean theUseDir, Boolean theRotate, float theVolAngle, UInt32 theMode, UInt32 theOptions, char *thePathName);
void								VRMoov_PlayTransitionMovie (WindowObject theWindowObject, UInt32 theOptions, char *thePathName);
Boolean								VRMoov_LoadEmbeddedMovie (char *thePathName, WindowObject theWindowObject, VRScriptMoviePtr theEntry);
void								VRMoov_LoopEmbeddedMovie (Movie theMovie);
Boolean								VRMoov_DoIdle (WindowObject theWindowObject);
void								VRMoov_DumpNodeMovies (WindowObject theWindowObject);
void								VRMoov_DumpSceneMovies (WindowObject theWindowObject);
void								VRMoov_DumpSelectedMovies (WindowObject theWindowObject, UInt32 theOptions);
VRScriptMoviePtr					VRMoov_GetEmbeddedVideo (WindowObject theWindowObject);
float								VRMoov_GetEmbeddedMovieWidth (WindowObject theWindowObject);
void								VRMoov_SetEmbeddedMovieWidth (WindowObject theWindowObject, float theWidth);
void								VRMoov_GetEmbeddedMovieCenter (WindowObject theWindowObject, QTVRFloatPoint *theCenter);
void								VRMoov_SetEmbeddedMovieCenter (WindowObject theWindowObject, const QTVRFloatPoint *theCenter);
float								VRMoov_GetEmbeddedMovieScale (WindowObject theWindowObject);
void								VRMoov_SetEmbeddedMovieScale (WindowObject theWindowObject, float theScale);
void								VRMoov_GetEmbeddedMovieRect (WindowObject theWindowObject, Rect *theRect);
void								VRMoov_SetEmbeddedMovieRect (WindowObject theWindowObject, const Rect *theRect);
void								VRMoov_SetAllBalanceAndVolume (WindowObject theWindowObject, float thePan, float theTilt);
void								VRMoov_SetOneBalanceAndVolume (Movie theMovie, MediaHandler theMediaHandler, float thePan, float theTilt, float theMoviePan, float theVolAngle);
PASCAL_RTN OSErr					VRMoov_BackBufferImagingProc (QTVRInstance theInstance, Rect *theRect, UInt16 theAreaIndex, UInt32 theFlagsIn, UInt32 *theFlagsOut, WindowObject theWindowObject);
PASCAL_RTN OSErr					VRMoov_CoverProc (Movie theMovie, RgnHandle theRegion, WindowObject theWindowObject);
void								VRMoov_SetVideoGraphicsMode (Movie theMovie, VRScriptMoviePtr theEntry, Boolean theSetVGM);
VRScriptMoviePtr					VRMoov_GetFinishedMovie (WindowObject theWindowObject);
void								VRMoov_CheckForCompletedMovies (WindowObject theWindowObject);
void								VRMoov_DumpEntryMem (VRScriptMoviePtr theEntry);
